<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Admin\UserMessage;
use App\Models\Admin\Website;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class UserMessageController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $keywords = ['JOB_REPORTED', 'PROVE_REPORTED', 'BALANCE_UPDATED', 'JOB_PAUSED', 'SYSTEM_REPLY'];
        $datas = UserMessage::whereIn('message_title', $keywords)
                        ->latest()
                        ->take(200) 
                        ->get();
       // $datas = UserMessage::latest()->take(400)->get();
        $users = User::where('role_id', 3)->latest()->get();
        $website = Website::latest()->first();
        return view('backend.pages.system-setting.user-message', compact('datas', 'users', 'website'));
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'message' => 'required',
        ]);

        $data = new UserMessage();
        $data->user_id = $request->input('user_id');
        $data->message_title = 'REPORT_ACTION';
        $data->message = Str::ucfirst($request->input('message'));
        $data->save();

        return redirect()->back()->with('message','Message send Successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = UserMessage::find($id);
        $data->delete();

        return redirect()->back()->with('message','Data deleted Successfully');
    }
}
